/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;

/**
 *
 * @author Elan
 */
public class DirectAPI {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(
			DirectAPI.class);
    public static boolean post(String endpoint, JSONObject data, String expectedResponse) {
        //Properties props = new Properties();
        //props.putAll(MailetProperties.getPropertiesList());
        boolean rtc = false;
        HttpURLConnection conn = null;
        DataOutputStream ds = null;
        Map<String, String> props = MailetProperties.getPropertiesList();
        try {
            URL url = new URL("https://" + props.get("direct.apiurl") + endpoint);
            conn = (HttpURLConnection) url.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "POST\n" + dstr + "\napplication/json\n" + (endpoint);
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String) props.get("direct.privatekey")).getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String) props.get("direct.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            // Allow Inputs
            conn.setDoInput(true);
            // Allow Outputs
            conn.setDoOutput(true);
            // Don't use a cached copy.
            conn.setUseCaches(false);
            // Use a post method.
            conn.setRequestMethod("POST");
            try {
                ds = new DataOutputStream(conn.getOutputStream());
                ds.write(data.toString().getBytes("UTF-8"));
                ds.flush();
                ds.close();
            } finally {
                if (ds != null) {
                    ds.close();
                }
            }

            //added the response message on failure as well, because it can help with debugging potentially
            if (conn.getResponseCode() != 200) {
                //Debugging code in-case response 200 is not received
                //LOGGER.error("DirectAPI: Failed : HTTP error code : " + conn.getResponseCode() + ". HTTP response : " + conn.getResponseMessage());
                return false;
            }
						try {
							final InputStreamReader stream = new InputStreamReader((conn.getInputStream()));
							try {
								final BufferedReader br = new BufferedReader(stream);
								String output;
								String resp = "";
								while ((output = br.readLine()) != null) {
									resp += output;
								}
								LOGGER.info(resp);
								if (resp.indexOf("\"message\":\"" + expectedResponse + "\"") >= 0) {
									rtc = true;
								}
							} finally {
								if(stream != null) {
									try {
										stream.close();
									} catch (IOException e) {
										LOGGER.error("DirectAPI: IO exception");
									}
								}
							}
						} catch (IOException e) {
							LOGGER.error("DirectAPI: IO exception");
						} 
        } catch (NoSuchAlgorithmException e) {
            LOGGER.error("DirectAPI: HmacSHA256 algrithm was not found");
        } catch (InvalidKeyException e) {
            LOGGER.error("DirectAPI: Secret Key is invalid");
        } catch (MalformedURLException e) {
            LOGGER.error("DirectAPI: malformed url");
        } catch (IOException e) {
            LOGGER.error("DirectAPI: IO exception");
        } finally {
            if (conn != null) {
                conn.disconnect();
            }

        }
				
        return rtc;
    }

   /* public static void main(String[] args) {
       
        Map<String, String> props = new HashMap<String, String>();
        props.put("direct.publickey", "REDACTED");
        props.put("direct.privatekey", "REDACTED");
        props.put("direct.apiurl", "api.dev.direct.DNS   ");
        JSONObject jo = new JSONObject();
        jo.put("mailbox", "tauser");
        jo.put("id", "4");
        //System.out.println(post(props, "/direct/messages/process_incoming", jo, "Message was successfully processed."));

        // System.out.println("send tauser@test.direct.DNS   : " + test.send("tauser@test.direct.DNS   ", "tauser@test.direct.DNS   ", "", "", "", "Test subject", "Test body", null, props));
    }*/
}
